using System;
using Server;
using Server.Items;

namespace Server.Mobiles
{
	//[CorpseName( "a corrosive slime corpse" )]
	public class CorrosiveSlime : Slime
	{
		[Constructable]
		public CorrosiveSlime() : base()
		{
			Name = "a corrosive slime";
		}
		
		public CorrosiveSlime( Serial serial ) : base( serial )
		{
		}	
		
		public override void OnDeath( Container c )
		{
			base.OnDeath( c );		
			
			if ( Utility.RandomDouble() < 0.3 )
			{
				Item item = new Klic();
            switch ( Utility.Random( 3 ) )
				{
					case 0:
					{
                  item.Name = "coagulated legs";
                  item.ItemID = 0x1CDF;
                  item.Hue = 1272;
                  item.Weight = 5;
               }
               break;
					case 1:
					{
                  item.Name = "partially digested torso";
                  item.ItemID = 0x1D9F;
                  item.Hue = 1272;
                  item.Weight = 10;
               }
               break;
					case 2:
					{
                  item.Name = "gelatanous skull";
                  item.ItemID = 0x1AE0;
                  item.Hue = 1272;
                  item.Weight = 1;
               }
               break;               
				}
            c.DropItem( item );
			}
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			
			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			
			int version = reader.ReadInt();
		}
	}
}
